/** @type {import('tailwindcss').Config} */
module.exports = {
    content: [
        "./src/**/*.{js,jsx,ts,tsx}",
    ],
    darkMode: 'class',
    theme: {
        extend: {
            colors: {
                primary: {
                    DEFAULT: "#3b82f6",
                    light: "#60a5fa",
                    dark: "#2563eb",
                    soft: "rgba(59, 130, 246, 0.1)",
                },
                secondary: "#10b981",
                accent: "#f59e0b",
                bg: {
                    light: "#f8fafc",
                    card: "#ffffff",
                    dark: "#0b0f19",
                    darkCard: "#111827",
                },
                slate: {
                    950: "#0b0f19",
                }
            },
            borderRadius: {
                '2xl': '1rem',
                '3xl': '1.5rem',
                '4xl': '2rem',
            },
            boxShadow: {
                'premium': '0 10px 30px -5px rgba(0, 0, 0, 0.05)',
                'premium-deep': '0 20px 40px -10px rgba(0, 0, 0, 0.1)',
            }
        },
    },
    plugins: [
        require("tailwindcss-animate")
    ],
}
