import api from './api';

const userService = {
    getAll: () => api.get('/users'),
    create: (data) => api.post('/users', data),
    update: (id, data) => api.put(`/users/${id}`, data),
    delete: (id) => api.delete(`/users/${id}`),
    toggleStatus: (id) => api.patch(`/users/${id}/status`),
    resetPassword: (id) => api.post(`/users/${id}/reset-password`),
    resendCredentials: (id) => api.post(`/users/${id}/resend-credentials`),
    getRoles: () => api.get('/users/meta/roles'),
};

export default userService;
