import api from './api';
import axios from 'axios';

const settingsService = {
    getPublicBranding: () => axios.get('http://localhost:5000/api/settings/public/branding'),
    getSettings: () => api.get('/settings'),
    updateSettings: (data) => api.post('/settings', data),
    testEmail: (data) => api.post('/settings/test-email', data),
    uploadLogo: (formData) => api.post('/settings/upload-logo', formData, {
        headers: { 'Content-Type': 'multipart/form-data' }
    }),
    getTaxRates: () => api.get('/settings/tax-rates'),
    createTaxRate: (data) => api.post('/settings/tax-rates', data),
    deleteTaxRate: (id) => api.delete(`/settings/tax-rates/${id}`),
};

export default settingsService;
