import api from './api';

const subscriptionService = {
    getAll: () => api.get('/subscriptions'),
    getById: (id) => api.get(`/subscriptions/${id}`),
    create: (data) => api.post('/subscriptions', data),
    update: (id, data) => api.put(`/subscriptions/${id}`, data),
    delete: (id) => api.delete(`/subscriptions/${id}`),
    createFromInvoice: (invoiceId, data) => api.post(`/subscriptions/from-invoice/${invoiceId}`, data),
    runScheduler: () => api.post('/subscriptions/run-scheduler'),
};

const reportService = {
    getProfitLoss: (params) => api.get('/reports/profit-loss', { params }),
    getBalanceSheet: () => api.get('/reports/balance-sheet'),
    getMetrics: () => api.get('/reports/metrics'),
};

export { subscriptionService, reportService };
