import api from './api';

const payrollService = {
    getEmployees: () => api.get('/payroll/employees'),
    createEmployee: (data) => api.post('/payroll/employees', data),
    updateEmployee: (id, data) => api.put(`/payroll/employees/${id}`, data),
    deleteEmployee: (id) => api.delete(`/payroll/employees/${id}`),
    getRuns: () => api.get('/payroll/runs'),
    createRun: (data) => api.post('/payroll/runs', data),
    markPaid: (id) => api.post(`/payroll/runs/${id}/pay`),
};

export default payrollService;
