import api from './api';

const incomeService = {
    getAll: (params) => api.get('/income', { params }),
    getById: (id) => api.get(`/income/${id}`),
    create: (data) => api.post('/income', data),
    update: (id, data) => api.put(`/income/${id}`, data),
    delete: (id) => api.delete(`/income/${id}`),
    getSummary: () => api.get('/income/summary'),
    getCategories: () => api.get('/income/meta/categories'),
    createCategory: (data) => api.post('/income/meta/categories', data),
    updateCategory: (id, data) => api.put(`/income/meta/categories/${id}`, data),
    deleteCategory: (id) => api.delete(`/income/meta/categories/${id}`),
};

export default incomeService;
