import api from './api';

const expenseService = {
    getAll: (params) => api.get('/expenses', { params }),
    getById: (id) => api.get(`/expenses/${id}`),
    create: (data) => {
        const isFormData = data instanceof FormData;
        return api.post('/expenses', data, {
            headers: isFormData ? { 'Content-Type': 'multipart/form-data' } : {}
        });
    },
    update: (id, data) => api.put(`/expenses/${id}`, data),
    delete: (id) => api.delete(`/expenses/${id}`),
    getSummary: () => api.get('/expenses/summary'),
    getCategories: () => api.get('/expenses/meta/categories'),
    createCategory: (data) => api.post('/expenses/meta/categories', data),
    updateCategory: (id, data) => api.put(`/expenses/meta/categories/${id}`, data),
    deleteCategory: (id) => api.delete(`/expenses/meta/categories/${id}`),
    getVendors: () => api.get('/expenses/meta/vendors'),
    createVendor: (data) => api.post('/expenses/meta/vendors', data),
    updateVendor: (id, data) => api.put(`/expenses/meta/vendors/${id}`, data),
    deleteVendor: (id) => api.delete(`/expenses/meta/vendors/${id}`),
    getExpensePDF: (id) => {
        const token = localStorage.getItem('token');
        return `http://localhost:5000/api/expenses/${id}/pdf?token=${encodeURIComponent(token)}`;
    },
};

export default expenseService;
