import axios from 'axios';

const API_URL = process.env.REACT_APP_API_URL || 'http://localhost:5000/api';

const crmService = {
    getStatus: () => {
        const token = localStorage.getItem('token');
        return axios.get(`${API_URL}/crm-import/status`, {
            headers: { Authorization: `Bearer ${token}` }
        });
    },
    runImport: () => {
        const token = localStorage.getItem('token');
        return axios.post(`${API_URL}/crm-import/run`, {}, {
            headers: { Authorization: `Bearer ${token}` }
        });
    }
};

export default crmService;
