import axios from 'axios';

const API_URL = 'http://localhost:5000/api/portal';

const clientPortalService = {
    getDashboard: () => axios.get(`${API_URL}/dashboard`),
    getInvoices: () => axios.get(`${API_URL}/invoices`),
    getQuotes: () => axios.get(`${API_URL}/quotes`),
    getPayments: () => axios.get(`${API_URL}/payments`),
    recordPayment: (data) => axios.post(`${API_URL}/payments/record`, data),
};

export default clientPortalService;
