import api from './api';

const billingService = {
    // Invoices
    getInvoices: () => api.get('/invoices'),
    getInvoiceById: (id) => api.get(`/invoices/${id}`),
    createInvoice: (data) => api.post('/invoices', data),
    updateInvoice: (id, data) => api.put(`/invoices/${id}`, data),
    deleteInvoice: (id) => api.delete(`/invoices/${id}`),
    markAsPaid: (id, data = {}) => api.post(`/invoices/${id}/paid`, data),
    sendInvoice: (id) => api.post(`/invoices/${id}/send`),
    getInvoicePDF: (id, mode = 'download') => {
        const token = localStorage.getItem('token');
        return `http://localhost:5000/api/invoices/${id}/pdf?mode=${mode}&token=${encodeURIComponent(token)}`;
    },
    convertQuote: (quoteId) => api.post(`/invoices/convert/${quoteId}`),

    // Quotes
    getQuotes: () => api.get('/quotes'),
    getQuoteById: (id) => api.get(`/quotes/${id}`),
    createQuote: (data) => api.post('/quotes', data),
    updateQuote: (id, data) => api.put(`/quotes/${id}`, data),
    deleteQuote: (id) => api.delete(`/quotes/${id}`),
    updateQuoteStatus: (id, status) => api.put(`/quotes/${id}/status`, { status }),
    sendQuote: (id) => api.post(`/quotes/${id}/send`),
    getQuotePDF: (id, mode = 'download') => {
        const token = localStorage.getItem('token');
        return `http://localhost:5000/api/quotes/${id}/pdf?mode=${mode}&token=${encodeURIComponent(token)}`;
    },

    // Clients
    getClients: () => api.get('/clients'),
    createClient: (data) => api.post('/clients', data),
    updateClient: (id, data) => api.put(`/clients/${id}`, data),
    deleteClient: (id) => api.delete(`/clients/${id}`),
};

export default billingService;
