import React, { useState } from 'react';
import { useAuth } from '../contexts/AuthContext';
import {
    User,
    Lock,
    Shield,
    Mail,
    Save,
    Loader2,
    CheckCircle,
    Fingerprint,
    ShieldCheck
} from 'lucide-react';
import { clsx } from 'clsx';

const ClientProfile = () => {
    const { user } = useAuth();
    const [loading, setLoading] = useState(false);

    return (
        <div className="space-y-10 animate-slide-up pb-20 max-w-2xl mx-auto">
            {/* Premium Header */}
            <div className="flex flex-col md:flex-row justify-between items-start md:items-center gap-6">
                <div className="flex items-center gap-4 sm:gap-5 min-w-0">
                    <div className="p-3 sm:p-4 bg-primary rounded-2xl text-white shadow-xl shadow-primary/20 shrink-0">
                        <Fingerprint className="w-6 h-6 sm:w-8 sm:h-8 shrink-0" />
                    </div>
                    <div className="min-w-0">
                        <h1 className="text-xl sm:text-2xl font-extrabold text-slate-800 dark:text-white tracking-tight leading-none truncate">Profile & Security</h1>
                        <div className="flex items-center gap-2 mt-1">
                            <span className="text-[10px] font-black text-slate-400 dark:text-slate-500 uppercase tracking-widest whitespace-nowrap">Manage Profile</span>
                            <div className="w-1 h-1 bg-slate-300 dark:bg-slate-700 rounded-full shrink-0"></div>
                            <span className="text-[10px] font-black text-primary uppercase tracking-widest whitespace-nowrap">Secure Account</span>
                        </div>
                    </div>
                </div>
            </div>

            <div className="premium-card overflow-hidden">
                <div className="p-6 sm:p-10 border-b border-slate-100 dark:border-slate-800/50 bg-slate-50/50 dark:bg-slate-900/40 flex items-center gap-4 sm:gap-6 relative min-w-0">
                    <div className="absolute top-0 right-0 w-32 h-32 -mr-16 -mt-16 bg-primary/5 rounded-full blur-2xl pointer-events-none shrink-0" />
                    <div className="w-16 h-16 sm:w-20 sm:h-20 bg-primary/10 dark:bg-primary/20 rounded-2xl sm:rounded-[2rem] flex items-center justify-center text-primary text-2xl sm:text-3xl font-black border border-primary/20 shadow-inner group shrink-0">
                        <span className="group-hover:scale-110 transition-transform duration-500 shrink-0">{user?.fullName?.charAt(0)}</span>
                    </div>
                    <div className="min-w-0">
                        <h2 className="text-xl sm:text-2xl font-black text-slate-800 dark:text-white tracking-tight truncate whitespace-nowrap">{user?.fullName}</h2>
                        <p className="text-[9px] sm:text-[10px] font-black text-slate-400 dark:text-slate-500 uppercase tracking-[0.2em] mt-1 truncate whitespace-nowrap">Verified Account</p>
                    </div>
                </div>

                <form className="p-6 sm:p-10 space-y-8 sm:space-y-10 group" onSubmit={(e) => e.preventDefault()}>
                    <div className="space-y-4">
                        <label className="premium-label">Email Address</label>
                        <div className="relative">
                            <Mail className="absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-slate-300 dark:text-slate-700 shrink-0" />
                            <input
                                disabled
                                type="email"
                                className="premium-input !pl-12 !bg-slate-50/50 dark:!bg-slate-900/40 opacity-50 cursor-not-allowed font-bold h-12 sm:h-auto"
                                value={user?.email}
                                readOnly
                            />
                        </div>
                    </div>

                    <div className="pt-8 sm:pt-10 border-t border-slate-100 dark:border-slate-800 flex items-center gap-3 text-primary font-black text-[10px] uppercase tracking-[0.2em]">
                        <Shield className="w-4 h-4 shrink-0" />
                        <span>Update Password</span>
                    </div>

                    <div className="space-y-4">
                        <label className="premium-label">New Password</label>
                        <div className="relative group/input">
                            <Lock className="absolute left-4 top-1/2 -translate-y-1/2 w-5 h-5 text-slate-300 group-focus-within/input:text-primary transition-colors shrink-0" />
                            <input
                                type="password"
                                placeholder="12+ characters recommended"
                                className="premium-input !pl-12 h-12 sm:h-auto outline-none"
                            />
                        </div>
                    </div>

                    <button
                        type="button"
                        className="w-full btn-primary py-4 sm:py-5 !shadow-2xl flex items-center justify-center gap-3 hover:scale-[1.01] active:scale-[0.99] h-12 sm:h-auto"
                    >
                        {loading ? <Loader2 className="w-5 h-5 sm:w-6 sm:h-6 animate-spin shrink-0" /> : <><Save className="w-5 h-5 shrink-0" /> <span className="text-[10px] sm:text-[11px] font-black uppercase tracking-[0.2em] whitespace-nowrap">Update Password</span></>}
                    </button>
                </form>
            </div>

            <div className="flex items-center gap-4 sm:gap-5 p-6 sm:p-8 bg-blue-500/5 dark:bg-blue-500/10 rounded-[2rem] sm:rounded-[2.5rem] border border-blue-500/10 text-blue-600 dark:text-blue-400 group">
                <ShieldCheck className="w-6 h-6 sm:w-8 sm:h-8 shrink-0 group-hover:rotate-12 transition-transform duration-500" />
                <p className="text-[9px] sm:text-[10px] font-black uppercase tracking-widest leading-relaxed">
                    Security Tip: Use a strong password (minimum 12 characters, including symbols) to secure your account access and financial data.
                </p>
            </div>
        </div>
    );
};

export default ClientProfile;
