const crypto = require('crypto');

const generateSecurePassword = (length = 12) => {
    // Enforce minimum length of 10 as per requirements
    if (length < 10) length = 10;

    const uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    const lowercase = 'abcdefghijklmnopqrstuvwxyz';
    const numbers = '0123456789';
    const special = '!@#$%^&*()_+~`|}{[]:;?><,./-=';
    const allChars = uppercase + lowercase + numbers + special;

    let password = '';
    // Ensure at least one of each required type
    password += uppercase[crypto.randomInt(0, uppercase.length)];
    password += lowercase[crypto.randomInt(0, lowercase.length)];
    password += numbers[crypto.randomInt(0, numbers.length)];
    password += special[crypto.randomInt(0, special.length)];

    // Fill the rest
    for (let i = 4; i < length; i++) {
        password += allChars[crypto.randomInt(0, allChars.length)];
    }

    // Shuffle password
    password = password.split('').sort(() => 0.5 - Math.random()).join('');

    return password;
};

module.exports = { generateSecurePassword };
