const { AuditLog } = require('../models/foundation');

const logAction = async (userId, action, module, details = null, ipAddress = null) => {
    try {
        await AuditLog.create({
            userId,
            action,
            module,
            details: typeof details === 'object' ? JSON.stringify(details) : details,
            ipAddress
        });
    } catch (error) {
        console.error('Audit Log Error:', error);
    }
};

module.exports = { logAction };
