exports.invoiceEmailTemplate = (invoice, client, company) => {
    const primaryColor = '#4f46e5';
    const companyName = company.name || 'FINANCE PRO';
    const logoHtml = company.logoUrl ? `<img src="${company.logoUrl}" alt="${companyName}" class="logo">` : `<div style="font-size: 24px; font-weight: 900; color: ${primaryColor};">${companyName}</div>`;

    return `
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #334155; margin: 0; padding: 0; background-color: #f8fafc; }
            .container { max-width: 600px; margin: 20px auto; background: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1); border: 1px solid #e2e8f0; }
            .header { background-color: #ffffff; padding: 40px 30px; text-align: center; border-bottom: 1px solid #f1f5f9; }
            .logo { height: 50px; margin-bottom: 20px; }
            .content { padding: 40px 30px; }
            .footer { background-color: #f8fafc; padding: 30px; text-align: center; font-size: 12px; color: #64748b; border-top: 1px solid #f1f5f9; }
            .button { display: inline-block; padding: 14px 30px; font-size: 14px; font-weight: bold; color: #ffffff !important; background-color: ${primaryColor}; text-decoration: none; border-radius: 12px; margin-top: 25px; box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.3); }
            .invoice-details { background-color: #f8fafc; border-radius: 12px; padding: 20px; margin: 25px 0; border: 1px solid #f1f5f9; }
            .detail-row { display: flex; justify-content: space-between; margin-bottom: 8px; font-size: 13px; }
            .detail-label { color: #64748b; font-weight: 500; }
            .detail-value { color: #1e293b; font-weight: 700; }
            .amount-total { font-size: 24px; color: #1e293b; font-weight: 900; margin-top: 10px; }
            h1 { font-size: 22px; color: #0f172a; margin: 0; font-weight: 800; }
            p { margin: 10px 0; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                ${logoHtml}
                <h1>New Invoice Issued</h1>
                <p style="color: #64748b; margin-top: 5px;">Invoice #${invoice.invoiceNumber}</p>
            </div>
            
            <div class="content">
                <p>Hello <strong>${client.name}</strong>,</p>
                <p>A new invoice has been generated for your recent services. Please find the details below and the attached PDF for your records.</p>
                
                <div class="invoice-details">
                    <div class="detail-row">
                        <span class="detail-label">Invoice Number</span>
                        <span class="detail-value">${invoice.invoiceNumber}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Due Date</span>
                        <span class="detail-value">${invoice.dueDate}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Amount Due</span>
                        <div class="detail-value amount-total">${company.currency || 'KES'} ${parseFloat(invoice.total).toLocaleString()}</div>
                    </div>
                </div>
                
                <div style="text-align: center;">
                    <a href="${process.env.FRONTEND_URL || 'http://localhost:3000'}/portal/invoices/${invoice.id}" class="button">View & Pay Online</a>
                </div>
                
                <p style="margin-top: 30px; font-size: 14px;">If you have any questions regarding this invoice, please contact our support team.</p>
            </div>
            
            <div class="footer">
                <p>&copy; ${new Date().getFullYear()} ${companyName}. All rights reserved.</p>
                <p>This is an automated message, please do not reply directly to this email.</p>
                ${company.website ? `<p><a href="${company.website}" style="color: ${primaryColor}">${company.website}</a></p>` : ''}
            </div>
        </div>
    </body>
    </html>
    `;
};

exports.quoteEmailTemplate = (quote, client, company) => {
    const primaryColor = '#4f46e5';
    const companyName = company.name || 'FINANCE PRO';
    const logoHtml = company.logoUrl ? `<img src="${company.logoUrl}" alt="${companyName}" class="logo">` : `<div style="font-size: 24px; font-weight: 900; color: ${primaryColor};">${companyName}</div>`;

    return `
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #334155; margin: 0; padding: 0; background-color: #f8fafc; }
            .container { max-width: 600px; margin: 20px auto; background: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1); border: 1px solid #e2e8f0; }
            .header { background-color: #ffffff; padding: 40px 30px; text-align: center; border-bottom: 1px solid #f1f5f9; }
            .logo { height: 50px; margin-bottom: 20px; }
            .content { padding: 40px 30px; }
            .footer { background-color: #f8fafc; padding: 30px; text-align: center; font-size: 12px; color: #64748b; border-top: 1px solid #f1f5f9; }
            .button { display: inline-block; padding: 14px 30px; font-size: 14px; font-weight: bold; color: #ffffff !important; background-color: ${primaryColor}; text-decoration: none; border-radius: 12px; margin-top: 25px; box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.3); }
            .quote-details { background-color: #f8fafc; border-radius: 12px; padding: 20px; margin: 25px 0; border: 1px solid #f1f5f9; }
            .detail-row { display: flex; justify-content: space-between; margin-bottom: 8px; font-size: 13px; }
            .detail-label { color: #64748b; font-weight: 500; }
            .detail-value { color: #1e293b; font-weight: 700; }
            .amount-total { font-size: 24px; color: #1e293b; font-weight: 900; margin-top: 10px; }
            h1 { font-size: 22px; color: #0f172a; margin: 0; font-weight: 800; }
            p { margin: 10px 0; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                ${logoHtml}
                <h1>New Quote Received</h1>
                <p style="color: #64748b; margin-top: 5px;">Quote #${quote.quoteNumber}</p>
            </div>
            
            <div class="content">
                <p>Hello <strong>${client.name}</strong>,</p>
                <p>We've prepared a new quote for your request. Please review the details below and the attached PDF for more information.</p>
                
                <div class="quote-details">
                    <div class="detail-row">
                        <span class="detail-label">Quote Number</span>
                        <span class="detail-value">${quote.quoteNumber}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Valid Until</span>
                        <span class="detail-value">${quote.expiryDate || 'N/A'}</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Estimated Total</span>
                        <div class="detail-value amount-total">${company.currency || 'KES'} ${parseFloat(quote.total).toLocaleString()}</div>
                    </div>
                </div>
                
                <div style="text-align: center;">
                    <a href="${process.env.FRONTEND_URL || 'http://localhost:3000'}/portal/quotes/${quote.id}" class="button">View & Accept Online</a>
                </div>
                
                <p style="margin-top: 30px; font-size: 14px;">This quote is subject to our standard terms and conditions. If you have any questions, feel free to reach out.</p>
            </div>
            
            <div class="footer">
                <p>&copy; ${new Date().getFullYear()} ${companyName}. All rights reserved.</p>
                <p>This is an automated message, please do not reply directly to this email.</p>
                ${company.website ? `<p><a href="${company.website}" style="color: ${primaryColor}">${company.website}</a></p>` : ''}
            </div>
        </div>
    </body>
    </html>
    `;
};

exports.welcomeEmailTemplate = (user, password, company) => {
    const primaryColor = '#4f46e5';
    const companyName = company.name || 'FINANCE PRO';
    const loginUrl = company.loginUrl || 'http://localhost:3000/login';

    return `
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="utf-8">
        <style>
            body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #334155; max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { text-align: center; padding: 20px; border-bottom: 2px solid ${primaryColor}; }
            .content { padding: 30px 20px; background: #ffffff; }
            .credentials { background: #f8fafc; padding: 20px; border-radius: 8px; border: 1px solid #e2e8f0; margin: 20px 0; }
            .label { font-size: 12px; color: #64748b; text-transform: uppercase; letter-spacing: 0.5px; font-weight: bold; }
            .value { font-size: 16px; font-weight: 600; color: #0f172a; margin-bottom: 15px; font-family: monospace; }
            .button { display: inline-block; padding: 12px 24px; background-color: ${primaryColor}; color: white; text-decoration: none; border-radius: 6px; font-weight: bold; }
            .footer { margin-top: 30px; font-size: 12px; color: #94a3b8; text-align: center; }
        </style>
    </head>
    <body>
        <div class="header">
            <h2>Welcome to ${companyName}</h2>
        </div>
        <div class="content">
            <p>Hello <strong>${user.fullName}</strong>,</p>
            <p>Your account has been created successfully. You can now access the portal using the credentials below.</p>
            
            <div class="credentials">
                <div class="label">Email Address</div>
                <div class="value">${user.email}</div>
                
                <div class="label">Temporary Password</div>
                <div class="value">${password}</div>
            </div>

            <p>Please note: You will be required to change this password upon your first login.</p>

            <div style="text-align: center;">
                <a href="${loginUrl}" class="button">Log In Now</a>
            </div>
        </div>
        <div class="footer">
            <p>&copy; ${new Date().getFullYear()} ${companyName}. All rights reserved.</p>
        </div>
    </body>
    </html>
    `;
};
