const { sequelize } = require('./config/db');
require('./models/foundation');
require('./models/client');
require('./models/billing');
require('./models/expense');
require('./models/settings');
require('./models/subscription');
require('./models/payroll');
require('./models/budget');
require('./models/income');

async function updateSchema() {
    try {
        console.log('Synchronizing database schema...');
        await sequelize.sync({ alter: true });
        console.log('Database schema updated successfully.');
        process.exit(0);
    } catch (err) {
        console.error('Error updating database schema:', err);
        process.exit(1);
    }
}

updateSchema();
