import React from "react";
import "./AntiGravityFinance.css";

const AntiGravityReceipt = ({ company, client, receiptNo, date, items, amountPaid, paymentMethod }) => {
    const subtotal = items.reduce((acc, item) => acc + item.qty * item.unitPrice, 0);
    const tax = subtotal * 0.16; // example VAT
    const total = subtotal + tax;
    const balance = total - amountPaid;

    return (
        <div className="anti-gravity-card finance-card">
            <h2>Receipt</h2>
            <div className="header">
                <div>
                    <h3>{company.name}</h3>
                    <p>{company.address}</p>
                    <p>{company.email}</p>
                </div>
                <div>
                    <p><strong>Receipt #:</strong> {receiptNo}</p>
                    <p><strong>Date:</strong> {date}</p>
                </div>
            </div>

            <div className="client">
                <p><strong>Received From:</strong> {client.name}</p>
                <p>{client.address}</p>
            </div>

            <table>
                <thead>
                    <tr>
                        <th>Description</th><th>Qty</th><th>Unit Price</th><th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    {items.map((item, i) => (
                        <tr key={i}>
                            <td>{item.desc}</td>
                            <td>{item.qty}</td>
                            <td>{item.unitPrice.toFixed(2)}</td>
                            <td>{(item.qty * item.unitPrice).toFixed(2)}</td>
                        </tr>
                    ))}
                </tbody>
            </table>

            <div className="totals">
                <p>Subtotal: {subtotal.toFixed(2)}</p>
                <p>Tax (16%): {tax.toFixed(2)}</p>
                <p>Total: {total.toFixed(2)}</p>
                <hr />
                <p><strong>Amount Paid:</strong> {amountPaid.toFixed(2)}</p>
                <p><strong>Balance:</strong> {balance.toFixed(2)}</p>
                <p><strong>Payment Method:</strong> {paymentMethod}</p>
            </div>
        </div>
    );
};

export default AntiGravityReceipt;