import React from "react";
import "./AntiGravityFinance.css";

const AntiGravityInvoice = ({ company, client, items, invoiceNo, date, type = 'Invoice', theme = 'Professional', discount = 0, subtotal = 0, tax = 0, total = 0 }) => {
    const currency = company.currency || 'KES';
    const isCompact = theme === 'Compact';

    return (
        <div className={`anti-gravity-document-container theme-${theme.toLowerCase()}`}>
            <div className={`anti-gravity-card finance-card premium-shadow ${isCompact ? 'compact-padding' : ''}`}>
                <div className="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-blue-600 to-indigo-600" />

                <div className="document-header">
                    <div className="company-branding">
                        {company.logo ? (
                            <img src={company.logo} alt={company.name} className="brand-logo" />
                        ) : (
                            <div className="brand-placeholder">
                                {company.name ? company.name.charAt(0) : 'F'}
                            </div>
                        )}
                        <div className="company-info">
                            <h3 className="company-name">{company.name || 'FINANCEPRO'}</h3>
                            <p className="detail-text">{company.address}</p>
                            <p className="detail-text">{company.city}</p>
                            <p className="detail-text">{company.phone}</p>
                        </div>
                    </div>

                    <div className="document-meta">
                        <h1 className="document-type">{type.toUpperCase()}</h1>
                        <div className="meta-grid">
                            <div className="meta-item">
                                <span className="label">#</span>
                                <span className="value">{invoiceNo}</span>
                            </div>
                            <div className="meta-item">
                                <span className="label">Date</span>
                                <span className="value">{date}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div className="billing-section">
                    <div className="billing-box">
                        <span className="section-label text-blue-600">Bill To:</span>
                        <h4 className="client-name">{client.name}</h4>
                        <p className="detail-text">{client.billingAddress || client.address}</p>
                        <p className="detail-text">{client.email}</p>
                    </div>
                </div>

                <div className="items-table-container">
                    <table className="items-table">
                        <thead>
                            <tr>
                                <th className="text-left">Description</th>
                                <th className="text-center">Qty</th>
                                <th className="text-right">Price</th>
                                <th className="text-right">Tax</th>
                                <th className="text-right">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            {items.map((item, i) => (
                                <tr key={i} className="item-row">
                                    <td className="desc-cell font-bold">{item.description}</td>
                                    <td className="qty-cell text-center">{item.quantity}</td>
                                    <td className="price-cell text-right">{Number(item.unitPrice).toLocaleString()}</td>
                                    <td className="tax-cell text-right">{item.taxRate || 0}%</td>
                                    <td className="total-cell text-right font-bold">
                                        {((Number(item.quantity) * Number(item.unitPrice)) + (Number(item.taxAmount) || 0)).toLocaleString()}
                                    </td>
                                </tr>
                            ))}
                        </tbody>
                    </table>
                </div>

                <div className="document-summary">
                    <div className="notes-section">
                        {company.taxNotes && (
                            <div className="notes-box">
                                <span className="notes-label">Notes:</span>
                                <p className="notes-text text-slate-500">{company.taxNotes}</p>
                            </div>
                        )}
                    </div>

                    <div className="totals-section">
                        <div className="summary-row">
                            <span className="label">Subtotal</span>
                            <span className="value">{currency} {Number(subtotal).toLocaleString()}</span>
                        </div>
                        <div className="summary-row">
                            <span className="label">Tax Sum</span>
                            <span className="value">{currency} {Number(tax).toLocaleString()}</span>
                        </div>
                        {Number(discount) > 0 && (
                            <div className="summary-row text-rose-500">
                                <span className="label">Discount</span>
                                <span className="value">-{currency} {Number(discount).toLocaleString()}</span>
                            </div>
                        )}
                        <div className="grand-total-row">
                            <span className="label">Total Amount</span>
                            <span className="value">{currency} {Number(total).toLocaleString()}</span>
                        </div>
                    </div>
                </div>

                <div className="document-footer text-center">
                    <p className="thank-you text-blue-600 font-bold">Thank you for your business!</p>
                </div>
            </div>
        </div>
    );
};

export default AntiGravityInvoice;