import React from "react";
import "./AntiGravityFinance.css";

const AntiGravityEstimate = ({ company, client, items, estimateNo, date, validity }) => {
    const subtotal = items.reduce((acc, item) => acc + item.qty * item.unitPrice, 0);
    const tax = subtotal * 0.16;
    const total = subtotal + tax;

    return (
        <div className="anti-gravity-card finance-card">
            <h2>Estimate</h2>
            <div className="header">
                <div>
                    <h3>{company.name}</h3>
                    <p>{company.address}</p>
                    <p>{company.email}</p>
                </div>
                <div>
                    <p><strong>Estimate #:</strong> {estimateNo}</p>
                    <p><strong>Date:</strong> {date}</p>
                    <p><strong>Valid Until:</strong> {validity}</p>
                </div>
            </div>

            <div className="client">
                <p><strong>Client:</strong> {client.name}</p>
                <p>{client.address}</p>
            </div>

            <table>
                <thead>
                    <tr>
                        <th>Description</th><th>Qty</th><th>Unit Price</th><th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    {items.map((item, i) => (
                        <tr key={i}>
                            <td>{item.desc}</td>
                            <td>{item.qty}</td>
                            <td>{item.unitPrice.toFixed(2)}</td>
                            <td>{(item.qty * item.unitPrice).toFixed(2)}</td>
                        </tr>
                    ))}
                </tbody>
            </table>

            <div className="totals">
                <p>Subtotal: {subtotal.toFixed(2)}</p>
                <p>Tax (16%): {tax.toFixed(2)}</p>
                <h3>Estimate Total: {total.toFixed(2)}</h3>
            </div>
        </div>
    );
};

export default AntiGravityEstimate;