const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);
router.use(authorize('SUPER_ADMIN')); // Only Super Admins can manage users

router.get('/', userController.getUsers);
router.post('/', userController.createUser);
router.put('/:id', userController.updateUser);
router.delete('/:id', userController.deleteUser);
router.patch('/:id/status', userController.toggleStatus);
router.post('/:id/reset-password', userController.resetPassword);
router.post('/:id/resend-credentials', userController.resendCredentials);
router.get('/meta/roles', userController.getRoles);

module.exports = router;
