const express = require('express');
const router = express.Router();
const subscriptionController = require('../controllers/subscriptionController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);

router.get('/', authorize('VIEW_FINANCIALS'), subscriptionController.getSubscriptions);
router.post('/', authorize('MANAGE_FINANCIALS'), subscriptionController.createSubscription);
router.get('/:id', authorize('VIEW_FINANCIALS'), subscriptionController.getSubscription);
router.post('/from-invoice/:invoiceId', authorize('MANAGE_FINANCIALS'), subscriptionController.createFromInvoice);
router.put('/:id', authorize('MANAGE_FINANCIALS'), subscriptionController.updateSubscription);
router.delete('/:id', authorize('MANAGE_FINANCIALS'), subscriptionController.deleteSubscription);

// Manual trigger for scheduler (for testing or manual runs)
router.post('/run-scheduler', authorize('MANAGE_FINANCIALS'), subscriptionController.runScheduler);

module.exports = router;
