const express = require('express');
const router = express.Router();
const staffController = require('../controllers/staffController');
const { protect, authorize } = require('../middlewares/auth');

// All staff routes are protected
router.use(protect);

router.get('/', authorize('SUPER_ADMIN', 'FINANCE', 'HR'), staffController.getStaff);
router.post('/', authorize('SUPER_ADMIN', 'HR'), staffController.createStaff);
router.get('/:id', authorize('SUPER_ADMIN', 'FINANCE', 'HR'), staffController.getStaffById);
router.put('/:id', authorize('SUPER_ADMIN', 'HR'), staffController.updateStaff);
router.delete('/:id', authorize('SUPER_ADMIN', 'HR'), staffController.deleteStaff);

module.exports = router;
