const express = require('express');
const router = express.Router();
const staffPaymentController = require('../controllers/staffPaymentController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);

router.post('/', authorize('SUPER_ADMIN', 'FINANCE', 'HR'), staffPaymentController.createPayment);
router.get('/', authorize('SUPER_ADMIN', 'FINANCE', 'HR'), staffPaymentController.getPayments);
router.put('/:id/status', authorize('SUPER_ADMIN', 'FINANCE'), staffPaymentController.updatePaymentStatus);
router.delete('/:id', authorize('SUPER_ADMIN', 'FINANCE'), staffPaymentController.deletePayment);

module.exports = router;
