const express = require('express');
const router = express.Router();
const settingsController = require('../controllers/settingsController');
const { protect, authorize } = require('../middlewares/auth');
const upload = require('../middlewares/upload');

// Public route - no authentication required
router.get('/public/branding', settingsController.getPublicBranding);

router.use(protect);
router.use(authorize('SUPER_ADMIN')); // Only Super Admins can manage system settings

router.get('/', settingsController.getSettings);
router.post('/', settingsController.updateSettings);
router.post('/test-email', settingsController.testEmail);
router.post('/upload-logo', upload.single('logo'), settingsController.uploadLogo);

// Tax Rates
router.get('/tax-rates', settingsController.getTaxRates);
router.post('/tax-rates', settingsController.createTaxRate);
router.delete('/tax-rates/:id', settingsController.deleteTaxRate);

module.exports = router;
