const express = require('express');
const router = express.Router();
const reportController = require('../controllers/reportController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);

router.get('/profit-loss', authorize('VIEW_FINANCIALS'), reportController.getProfitLoss);
router.get('/balance-sheet', authorize('VIEW_FINANCIALS'), reportController.getBalanceSheet);
router.get('/metrics', authorize('VIEW_FINANCIALS'), reportController.getMetrics);

module.exports = router;
