const express = require('express');
const router = express.Router();
const quoteController = require('../controllers/quoteController');
const { protect, authorize, isolateClient } = require('../middlewares/auth');

// All quote routes are protected
router.use(protect);

router.get('/', authorize('VIEW_QUOTES', 'CLIENT'), isolateClient, quoteController.getQuotes);
router.post('/', authorize('MANAGE_QUOTES'), quoteController.createQuote);
router.get('/:id', authorize('VIEW_QUOTES', 'CLIENT'), isolateClient, quoteController.getQuote);
router.put('/:id', authorize('MANAGE_QUOTES'), quoteController.updateQuote);
router.delete('/:id', authorize('MANAGE_QUOTES'), quoteController.deleteQuote);
router.put('/:id/status', authorize('MANAGE_QUOTES'), quoteController.updateStatus);
router.get('/:id/pdf', authorize('VIEW_QUOTES', 'CLIENT'), isolateClient, quoteController.downloadPDF);
router.post('/:id/send', authorize('MANAGE_QUOTES'), quoteController.sendByEmail);

module.exports = router;
