const express = require('express');
const router = express.Router();
const payrollController = require('../controllers/payrollController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);
router.use(authorize('SUPER_ADMIN', 'HR', 'FINANCE'));

// Employees (Read-only list, managed in Staff module)
router.get('/employees', payrollController.getEmployees);

// Runs
router.get('/runs', payrollController.getRuns);
router.post('/runs', payrollController.createRun);
router.post('/runs/:id/pay', authorize('SUPER_ADMIN', 'FINANCE'), payrollController.markPaid); // Only Finance can pay

module.exports = router;
