const express = require('express');
const router = express.Router();
const invoiceController = require('../controllers/invoiceController');
const { protect, authorize, isolateClient } = require('../middlewares/auth');

// All invoice routes are protected
router.use(protect);

router.get('/', authorize('VIEW_INVOICES', 'CLIENT'), isolateClient, invoiceController.getInvoices);
router.post('/', authorize('MANAGE_INVOICES'), invoiceController.createInvoice);
router.get('/:id', authorize('VIEW_INVOICES', 'CLIENT'), isolateClient, invoiceController.getInvoice);
router.put('/:id', authorize('MANAGE_INVOICES'), invoiceController.updateInvoice);
router.delete('/:id', authorize('MANAGE_INVOICES'), invoiceController.deleteInvoice);
router.post('/:id/paid', authorize('MANAGE_INVOICES'), invoiceController.markPaid);
router.post('/:id/send', authorize('MANAGE_INVOICES'), invoiceController.sendByEmail);
router.get('/:id/pdf', authorize('VIEW_INVOICES', 'CLIENT'), isolateClient, invoiceController.downloadPDF);
router.post('/convert/:quoteId', authorize('MANAGE_INVOICES'), invoiceController.convertQuote);

module.exports = router;
