const express = require('express');
const router = express.Router();

const authRoutes = require('./authRoutes');
const incomeRoutes = require('./incomeRoutes');
const expenseRoutes = require('./expenseRoutes');
const billingRoutes = require('./billingRoutes');
const subscriptionRoutes = require('./subscriptionRoutes');
const reportRoutes = require('./reportRoutes');
const clientPortalRoutes = require('./clientPortalRoutes');
const crmImportRoutes = require('./crmImportRoutes');
const settingsRoutes = require('./settingsRoutes');
const staffRoutes = require('./staffRoutes');

// --- Auth Routes ---
router.use('/auth', authRoutes);

// --- Financial & Management Modules ---
router.use('/income', incomeRoutes);
router.use('/expenses', expenseRoutes);
router.use('/billing', billingRoutes);
router.use('/subscriptions', subscriptionRoutes);
router.use('/reports', reportRoutes);
router.use('/crm-import', crmImportRoutes);
router.use('/crm-import', crmImportRoutes);
router.use('/crm-import', crmImportRoutes);
router.use('/settings', settingsRoutes);
router.use('/clients', require('./clientRoutes'));

// --- New Modules ---
router.use('/users', require('./userRoutes'));
router.use('/payroll', require('./payrollRoutes'));
router.use('/budgets', require('./budgetRoutes'));
router.use('/staff', staffRoutes);
router.use('/staff-payments', require('./staffPaymentRoutes'));
router.use('/banking', require('./bankRoutes'));

// --- Client Portal ---
router.use('/portal', clientPortalRoutes);

// --- Direct access routes (for frontend compatibility) ---
router.use('/invoices', require('./invoiceRoutes'));
router.use('/quotes', require('./quoteRoutes'));

// --- Dashboard ---
router.use('/dashboard', require('./dashboardRoutes'));
// router.use('/expenses', require('./expenseRoutes'));
// router.use('/invoices', require('./invoiceRoutes'));
// router.use('/quotes', require('./quoteRoutes'));
// router.use('/recurring', require('./recurringRoutes'));
// router.use('/payroll', require('./payrollRoutes'));
// router.use('/budgets', require('./budgetRoutes'));
// router.use('/reports', require('./reportRoutes'));

module.exports = router;
