const express = require('express');
const router = express.Router();
const incomeController = require('../controllers/incomeController');
const { protect, authorize } = require('../middlewares/auth');

// All income routes are protected
router.use(protect);

// Basic CRUD
router.get('/', authorize('VIEW_FINANCIALS'), incomeController.getIncomes);
router.post('/', authorize('MANAGE_FINANCIALS'), incomeController.createIncome);
router.get('/summary', authorize('VIEW_FINANCIALS'), incomeController.getSummary);
router.get('/:id', authorize('VIEW_FINANCIALS'), incomeController.getIncome);
router.put('/:id', authorize('MANAGE_FINANCIALS'), incomeController.updateIncome);
router.delete('/:id', authorize('MANAGE_FINANCIALS'), incomeController.deleteIncome);

// Categories
router.get('/meta/categories', authorize('VIEW_FINANCIALS'), incomeController.getCategories);
router.post('/meta/categories', authorize('MANAGE_FINANCIALS'), incomeController.createCategory);
router.put('/meta/categories/:id', authorize('MANAGE_FINANCIALS'), incomeController.updateCategory);
router.delete('/meta/categories/:id', authorize('MANAGE_FINANCIALS'), incomeController.deleteCategory);

module.exports = router;
