const express = require('express');
const router = express.Router();
const expenseController = require('../controllers/expenseController');
const { protect, authorize } = require('../middlewares/auth');

// All expense routes are protected
router.use(protect);

// Basic CRUD
router.get('/', authorize('VIEW_FINANCIALS'), expenseController.getExpenses);
router.post('/', authorize('MANAGE_FINANCIALS'), require('../middlewares/upload').single('receipt'), expenseController.createExpense);
router.get('/summary', authorize('VIEW_FINANCIALS'), expenseController.getSummary);
router.get('/:id', authorize('VIEW_FINANCIALS'), expenseController.getExpense);
router.get('/:id/pdf', authorize('VIEW_FINANCIALS'), expenseController.downloadPDF);
router.put('/:id', authorize('MANAGE_FINANCIALS'), require('../middlewares/upload').single('receipt'), expenseController.updateExpense);
router.delete('/:id', authorize('MANAGE_FINANCIALS'), expenseController.deleteExpense);

// Categories
router.get('/meta/categories', authorize('VIEW_FINANCIALS'), expenseController.getCategories);
router.post('/meta/categories', authorize('MANAGE_FINANCIALS'), expenseController.createCategory);
router.put('/meta/categories/:id', authorize('MANAGE_FINANCIALS'), expenseController.updateCategory);
router.delete('/meta/categories/:id', authorize('MANAGE_FINANCIALS'), expenseController.deleteCategory);

// Vendors
router.get('/meta/vendors', authorize('VIEW_FINANCIALS'), expenseController.getVendors);
router.post('/meta/vendors', authorize('MANAGE_FINANCIALS'), expenseController.createVendor);
router.put('/meta/vendors/:id', authorize('MANAGE_FINANCIALS'), expenseController.updateVendor);
router.delete('/meta/vendors/:id', authorize('MANAGE_FINANCIALS'), expenseController.deleteVendor);

module.exports = router;
