const express = require('express');
const router = express.Router();
const crmController = require('../controllers/CrmMpesaImportController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);
router.use(authorize('SUPER_ADMIN', 'FINANCE'));

router.post('/run', crmController.runImport);
router.get('/status', crmController.getStatus);

module.exports = router;
