const express = require('express');
const router = express.Router();
const clientController = require('../controllers/clientController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);

router.get('/', authorize('VIEW_CLIENTS'), clientController.getClients);
router.get('/:id', authorize('VIEW_CLIENTS'), clientController.getClient);
router.post('/', authorize('MANAGE_CLIENTS'), clientController.createClient);
router.put('/:id', authorize('MANAGE_CLIENTS'), clientController.updateClient);
router.delete('/:id', authorize('MANAGE_CLIENTS'), clientController.deleteClient);

module.exports = router;
