const express = require('express');
const router = express.Router();
const portalController = require('../controllers/clientPortalController');
const { protect, authorize, isolateClient } = require('../middlewares/auth');

// All routes require CLIENT authorization
router.use(protect);
router.use(authorize('CLIENT'));
router.use(isolateClient);

router.get('/dashboard', portalController.getDashboard);
router.get('/invoices', portalController.getInvoices);
router.get('/quotes', portalController.getQuotes);
router.get('/payments', portalController.getPayments);

// Mock payment recording (for manual bank transfer notifications)
router.post('/payments/record', portalController.recordPayment);

module.exports = router;
