const express = require('express');
const router = express.Router();
const budgetController = require('../controllers/budgetController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);

router.post('/', authorize('SUPER_ADMIN', 'FINANCE'), budgetController.setBudget);
router.get('/status', authorize('SUPER_ADMIN', 'FINANCE'), budgetController.getStatus);
router.delete('/:id', authorize('SUPER_ADMIN', 'FINANCE'), budgetController.deleteBudget);

module.exports = router;
