const express = require('express');
const router = express.Router();
const invoiceController = require('../controllers/invoiceController');
const quoteController = require('../controllers/quoteController');
const { protect, authorize, isolateClient } = require('../middlewares/auth');

// All billing routes are protected
router.use(protect);

// Invoices
router.get('/invoices', authorize('VIEW_INVOICES', 'CLIENT'), isolateClient, invoiceController.getInvoices);
router.post('/invoices', authorize('MANAGE_INVOICES'), invoiceController.createInvoice);
router.get('/invoices/:id', authorize('VIEW_INVOICES', 'CLIENT'), isolateClient, invoiceController.getInvoice);
router.post('/invoices/:id/paid', authorize('MANAGE_INVOICES'), invoiceController.markPaid);
router.post('/invoices/:id/send', authorize('MANAGE_INVOICES'), invoiceController.sendByEmail);
router.get('/invoices/:id/pdf', authorize('VIEW_INVOICES', 'CLIENT'), isolateClient, invoiceController.downloadPDF);
router.post('/invoices/convert/:quoteId', authorize('MANAGE_INVOICES'), invoiceController.convertQuote);

// Quotes
router.get('/quotes', authorize('VIEW_QUOTES', 'CLIENT'), isolateClient, quoteController.getQuotes);
router.post('/quotes', authorize('MANAGE_QUOTES'), quoteController.createQuote);
router.get('/quotes/:id', authorize('VIEW_QUOTES', 'CLIENT'), isolateClient, quoteController.getQuote);
router.put('/quotes/:id/status', authorize('MANAGE_QUOTES'), quoteController.updateStatus);
router.get('/quotes/:id/pdf', authorize('VIEW_QUOTES', 'CLIENT'), isolateClient, quoteController.downloadPDF);
router.post('/quotes/:id/send', authorize('MANAGE_QUOTES'), quoteController.sendByEmail);

module.exports = router;
