const express = require('express');
const router = express.Router();
const bankController = require('../controllers/bankController');
const { protect, authorize } = require('../middlewares/auth');

router.use(protect);

router.post('/', authorize('MANAGE_FINANCIALS'), bankController.createAccount);
router.get('/', authorize('VIEW_FINANCIALS'), bankController.getAccounts);
router.get('/:id/transactions', authorize('VIEW_FINANCIALS'), bankController.getTransactions);
router.patch('/:id/default', authorize('MANAGE_FINANCIALS'), bankController.setDefault);

module.exports = router;
