const { sequelize } = require('./config/db');
const { User } = require('./models/foundation');
const bcrypt = require('bcryptjs');

const reset = async () => {
    try {
        await sequelize.sync({ force: false });

        const user = await User.findOne({ where: { email: 'admin@financepro.com' } });

        if (!user) {
            console.log('❌ User admin@financepro.com not found');
            process.exit(1);
        }

        const password = await bcrypt.hash('ocCT*WFt%%fhjKrO', 10);
        user.password = password;
        await user.save();

        console.log('✅ Password successfully updated for admin@financepro.com');
        process.exit(0);
    } catch (err) {
        console.error('❌ Reset failed:', err);
        process.exit(1);
    }
};

reset();
