const { sequelize } = require('./config/db');
const { User } = require('./models/foundation');
const bcrypt = require('bcryptjs');

const reset = async () => {
    try {
        await sequelize.authenticate();
        const password = await bcrypt.hash('password123', 10);

        const [updated] = await User.update({ password }, {
            where: { email: 'lawreyk@gmail.com' }
        });

        if (updated) {
            console.log('✅ Password for lawreyk@gmail.com reset to password123');
        } else {
            console.log('❌ User lawreyk@gmail.com not found');
        }

    } catch (err) {
        console.error('Error:', err);
    } finally {
        process.exit();
    }
}

reset();
