const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/db');

const StaffPayment = sequelize.define('StaffPayment', {
    id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
    staffId: {
        type: DataTypes.UUID,
        allowNull: false,
        references: {
            model: 'Staff',
            key: 'id'
        }
    },
    periodStart: { type: DataTypes.DATEONLY, allowNull: false },
    periodEnd: { type: DataTypes.DATEONLY, allowNull: false },
    amount: { type: DataTypes.DECIMAL(15, 2), defaultValue: 0 },
    status: {
        type: DataTypes.ENUM('Pending', 'Paid'),
        defaultValue: 'Pending'
    },
    paymentDate: { type: DataTypes.DATE },
    paymentMethod: { type: DataTypes.STRING }, // M-Pesa, Cash, Bank
    paymentReference: { type: DataTypes.STRING },

    // Breakdown of how this was calculated
    // For Sales-based: [{ building: 'Name', count: 5, rate: 700, total: 3500 }]
    // For Daily-based: { days: 5, rate: 1000, total: 5000 }
    calculationBreakdown: { type: DataTypes.TEXT },

    notes: { type: DataTypes.TEXT }
}, {
    tableName: 'StaffPayments',
    timestamps: true
});

module.exports = { StaffPayment };
