const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/db');

const Staff = sequelize.define('Staff', {
    id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
    fullName: { type: DataTypes.STRING, allowNull: false },
    position: { type: DataTypes.STRING, allowNull: false },
    email: { type: DataTypes.STRING, unique: true },
    phone: { type: DataTypes.STRING },
    gender: {
        type: DataTypes.ENUM('Male', 'Female', 'Other'),
        allowNull: true
    },
    staffType: {
        type: DataTypes.ENUM('Permanent', 'Temporary'),
        allowNull: false,
        defaultValue: 'Permanent'
    },
    // Permanent Staff Fields
    monthlySalary: { type: DataTypes.DECIMAL(15, 2), defaultValue: 0 },
    allowance: { type: DataTypes.DECIMAL(15, 2), defaultValue: 0 },

    // Temporary Staff Fields
    dailyRate: { type: DataTypes.DECIMAL(15, 2), defaultValue: 0 },
    payType: {
        type: DataTypes.ENUM('Daily', 'Commission', 'Sales'),
        defaultValue: 'Daily'
    },
    commissionPercentage: { type: DataTypes.DECIMAL(5, 2), defaultValue: 0 },
    buildingRates: {
        type: DataTypes.JSON, // [{ building: '', fullRate: 0, halfRate: 0 }]
        allowNull: true,
        defaultValue: []
    },

    isActive: { type: DataTypes.BOOLEAN, defaultValue: true },
    notes: { type: DataTypes.TEXT }
}, {
    tableName: 'Staff',
    timestamps: true
});

module.exports = { Staff };
