const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/db');

const SystemSetting = sequelize.define('SystemSetting', {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    key: { type: DataTypes.STRING, unique: true, allowNull: false },
    value: { type: DataTypes.TEXT },
    description: { type: DataTypes.STRING },
    isEncrypted: { type: DataTypes.BOOLEAN, defaultValue: false }
}, {
    tableName: 'SystemSettings',
    timestamps: true
});

const TaxRate = sequelize.define('TaxRate', {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    name: { type: DataTypes.STRING, allowNull: false },
    percentage: { type: DataTypes.DECIMAL(10, 2), allowNull: false, defaultValue: 0 },
    description: { type: DataTypes.STRING },
    isActive: { type: DataTypes.BOOLEAN, defaultValue: true }
}, {
    tableName: 'TaxRates',
    timestamps: true
});

module.exports = { SystemSetting, TaxRate };
