const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/db');
const { ExpenseCategory } = require('./expense');

const Budget = sequelize.define('Budget', {
    id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
    period: { type: DataTypes.STRING, allowNull: false }, // e.g. "2024-01" or "2024"
    amount: { type: DataTypes.DECIMAL(15, 2), allowNull: false },
    alertThreshold: { type: DataTypes.INTEGER, defaultValue: 80 }, // % to alert at
    createdBy: { type: DataTypes.UUID }
}, { timestamps: true });

// Relations
Budget.belongsTo(ExpenseCategory, { foreignKey: 'expenseCategoryId' });

module.exports = { Budget };
