const { sequelize } = require('./config/db');
const { DataTypes } = require('sequelize');

async function migrate() {
    try {
        const queryInterface = sequelize.getQueryInterface();
        const tableInfo = await queryInterface.describeTable('Subscriptions');

        if (!tableInfo.creditBalance) {
            console.log('Adding creditBalance column...');
            await queryInterface.addColumn('Subscriptions', 'creditBalance', {
                type: DataTypes.DECIMAL(15, 2),
                defaultValue: 0
            });
        }

        if (!tableInfo.gracePeriod) {
            console.log('Adding gracePeriod column...');
            await queryInterface.addColumn('Subscriptions', 'gracePeriod', {
                type: DataTypes.INTEGER,
                defaultValue: 5
            });
        }

        // Update ENUM for status
        console.log('Updating status enum to include Suspended...');
        // Note: Modern Sequelize/MySQL handles this via changeColumn
        await queryInterface.changeColumn('Subscriptions', 'status', {
            type: DataTypes.ENUM('Active', 'Paused', 'Cancelled', 'Suspended'),
            defaultValue: 'Active'
        });

        console.log('✅ Migration successful: creditBalance, gracePeriod, and Suspended status added.');
        process.exit(0);
    } catch (err) {
        console.error('❌ Migration failed:', err);
        process.exit(1);
    }
}

migrate();
