const cron = require('node-cron');
const subscriptionService = require('../services/subscriptionService');

const initSubscriptionJob = () => {
    console.log('📅 [Job] Subscription Billing Scheduler initialized (00:00 Daily)');

    // Schedule: 0 0 * * * (Daily at Midnight)
    cron.schedule('0 0 * * *', async () => {
        console.log('🚀 [Job] Running scheduled subscription billing...');
        try {
            const processed = await subscriptionService.processRecurringInvoices();
            console.log(`✅ [Job] Subscription billing completed. Processed: ${processed.length}`);
        } catch (err) {
            console.error('❌ [Job] Subscription billing failed:', err.message);
        }
    });
};

module.exports = { initSubscriptionJob };
