const { sequelize } = require('./config/db');

async function checkSchema() {
    try {
        const [results, metadata] = await sequelize.query("SHOW COLUMNS FROM Users");
        console.log("Columns in Users table:");
        results.forEach(col => {
            console.log(`- ${col.Field}: ${col.Type} (Default: ${col.Default})`);
        });
        process.exit(0);
    } catch (err) {
        console.error('Error:', err);
        process.exit(1);
    }
}

checkSchema();
