const { sequelize } = require('./config/db');
const { User, Role } = require('./models/foundation');
const bcrypt = require('bcryptjs');

const run = async () => {
    try {
        await sequelize.authenticate();
        console.log('DB Connected successfully.');

        const users = await User.findAll({
            include: [{ model: Role }]
        });

        console.log(`Found ${users.length} users.`);

        for (const user of users) {
            console.log('--------------------------------------------------');
            console.log(`Email: ${user.email}`);
            console.log(`Name: ${user.fullName}`);
            console.log(`Role: ${user.Role ? user.Role.constant : 'NONE'}`);
            console.log(`Active: ${user.isActive}`);

            const isPass123 = await bcrypt.compare('password123', user.password);
            const isAdmin123 = await bcrypt.compare('admin123', user.password);

            console.log(`Match 'password123': ${isPass123}`);
            console.log(`Match 'admin123': ${isAdmin123}`);
        }
        console.log('--------------------------------------------------');

    } catch (err) {
        console.error('Error:', err);
    } finally {
        process.exit();
    }
}

run();
