const mysql = require('mysql2/promise');
require('dotenv').config();

async function createDB() {
    const connection = await mysql.createConnection({
        host: process.env.DB_HOST || 'localhost',
        user: process.env.DB_USER || 'root',
        password: process.env.DB_PASS || '',
    });

    await connection.query(`CREATE DATABASE IF NOT EXISTS \`${process.env.DB_NAME || 'enterprise_finance_db'}\`;`);
    console.log('✅ Database created or already exists.');
    await connection.end();
}

createDB().catch(err => {
    console.error('❌ Failed to create database:', err.message);
    process.exit(1);
});
