const staffService = require('../services/staffService');

exports.createStaff = async (req, res) => {
    try {
        const staff = await staffService.createStaff(req.body, req.user.id);
        res.status(201).json(staff);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.getStaff = async (req, res) => {
    try {
        const staff = await staffService.getAllStaff(req.query);
        res.json(staff);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getStaffById = async (req, res) => {
    try {
        const staff = await staffService.getStaffById(req.params.id);
        if (!staff) return res.status(404).json({ message: 'Not found' });
        res.json(staff);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.updateStaff = async (req, res) => {
    try {
        const staff = await staffService.updateStaff(req.params.id, req.body, req.user.id);
        res.json(staff);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.deleteStaff = async (req, res) => {
    try {
        await staffService.deleteStaff(req.params.id, req.user.id);
        res.status(204).send();
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};
