const reportService = require('../services/reportService');

exports.getProfitLoss = async (req, res) => {
    try {
        const { startDate, endDate } = req.query;
        const report = await reportService.getProfitLoss(startDate, endDate);
        res.json(report);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getBalanceSheet = async (req, res) => {
    try {
        const report = await reportService.getBalanceSheet();
        res.json(report);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.getMetrics = async (req, res) => {
    try {
        const mrr = await reportService.getMRR();
        const { BankAccount } = require('../models/banking');
        const bankBalance = await BankAccount.sum('currentBalance', { where: { isActive: true } }) || 0;
        res.json({ mrr, bankBalance: Number(bankBalance) });
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};
