const payrollService = require('../services/payrollService');

exports.getEmployees = async (req, res) => {
    try {
        const employees = await payrollService.getEmployees();
        res.json(employees);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};



exports.createRun = async (req, res) => {
    try {
        const { month } = req.body;
        const run = await payrollService.createRun(month, req.user.id);
        res.status(201).json(run);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};

exports.getRuns = async (req, res) => {
    try {
        const runs = await payrollService.getRuns();
        res.json(runs);
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
};

exports.markPaid = async (req, res) => {
    try {
        const run = await payrollService.markPaid(req.params.id, req.user.id);
        res.json(run);
    } catch (err) {
        res.status(400).json({ error: err.message });
    }
};
